const handleMessage = (() => {
    const successToastBody = document.getElementById('successToastBody');
    const successToastContent = document.getElementById('successToastContent');
    const successCloseBtn = document.getElementById('successCloseBtn');

    const successCloseHandler = () => {
        chrome.runtime.sendMessage({
            action: CONSTANTS.ACTIONS.CLOSE_NOTIFICATION,
            type: CONSTANTS.NOTIFICATION_TYPES.SUCCESS
        });
    };

    const updateHeight = () => {
        const overflowBefore = document.body.style.overflow;
        document.body.style.overflow = CONSTANTS.VISIBILITY.HIDDEN;
        chrome.runtime.sendMessage({
            action: CONSTANTS.ACTIONS.SYNC_NOTIFICATION_SIZE,
            type: CONSTANTS.NOTIFICATION_TYPES.SUCCESS,
            width: successToastBody.scrollWidth,
            height: successToastBody.scrollHeight
        });
        document.body.style.overflow = overflowBefore;
    };

    return event => {
        if (!event.data.sender || event.data.sender !== CONSTANTS.MESSAGE_SENDERS.S7_NOTIFICATION) {
            return;
        }

        if (event.data.type !== CONSTANTS.NOTIFICATION_TYPES.SUCCESS) {
            return;
        }

        successToastContent.innerText = event.data.message;

        successCloseBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, successCloseHandler);

        updateHeight();
    }
})();

window.addEventListener(CONSTANTS.EVENTS.WINDOW.MESSAGE, handleMessage);
